/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import io.github.fabricators_of_create.porting_lib.core.event.BaseEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.CriticalHitEvent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_8103;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class DragonbornModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final TinkerDataCapability.TinkerDataKey<ModifierMaxLevel> DRAGONBORN = TConstruct.createKey("dragonborn");

    public DragonbornModifier() {
        super(DRAGONBORN);
        CriticalHitEvent.CRITICAL_HIT.register(DragonbornModifier::onCritical);
    }

    @Override
    protected ModifierMaxLevel createData() {
        return new ModifierMaxLevel();
    }

    private static boolean isAirborne(class_1309 living) {
        return !living.method_24828() && !living.method_6101() && !living.method_5799() && !living.method_5765();
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, int level, EquipmentContext context, class_1304 slotType, class_1282 source, float modifierValue) {
        if (!source.method_48789(class_8103.field_42243) && !source.method_48789(class_8103.field_42242) && DragonbornModifier.isAirborne(context.getEntity())) {
            modifierValue += this.getScaledLevel(tool, level) * 2.5f;
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        AbstractProtectionModifier.addResistanceTooltip(this, tool, level, 2.5f, tooltip);
    }

    private static void onCritical(CriticalHitEvent event) {
        if (event.getResult() != BaseEvent.Result.DENY) {
            class_1657 living = event.getEntity();
            TinkerDataCapability.CAPABILITY.maybeGet((Object)living).ifPresent(arg_0 -> DragonbornModifier.lambda$onCritical$0(event, (class_1309)living, arg_0));
        }
    }

    private static /* synthetic */ void lambda$onCritical$0(CriticalHitEvent event, class_1309 living, TinkerDataCapability.Holder data) {
        float max;
        ModifierMaxLevel dragonborn = data.get(DRAGONBORN);
        if (dragonborn != null && (max = dragonborn.getMax()) > 0.0f) {
            boolean isCritical;
            boolean bl = isCritical = event.isVanillaCritical() || event.getResult() == BaseEvent.Result.ALLOW;
            if (!isCritical && DragonbornModifier.isAirborne(living)) {
                isCritical = true;
                event.setResult(BaseEvent.Result.ALLOW);
            }
            if (isCritical) {
                event.setDamageModifier(event.getDamageModifier() + max * 0.05f);
            }
        }
    }
}

